
import fs from 'fs';
import path from 'path';

/* Run cmake-js with any arguments passed to this script. */
import { execFileSync } from 'child_process';
import process from 'process';

const __dirname = import.meta.dirname;

/* Log to a file */
// import util from 'util';
// let logFilePath = '/Users/abe/code/filmlab/node-photochemistry/debug.log';

// function log() {
//     fs.writeFileSync(logFilePath, util.format.apply(null, arguments) + '\n', {
//         flag: 'a',
//         mode: 0o644,
//         encoding: 'utf-8'
//     });
// }


let cmakeJSArgs = process.argv.slice(2);
// For backwards compatiblity with electron-rebuild we sometimes need to call this as an action from
// a binding.gyp file. Gyp files are old and weird, and when calling commands they automatically add
// a directory prefix to arguments that don't start with --. So we add -- just to avoid that bug,
// but then we need to remove it before passing the rest of the arguments to cmake-js.
const knownArgs = ["compile", "build", "configure", "install", "reconfigure", "clean"];
cmakeJSArgs = cmakeJSArgs.map(arg => {
    if (arg.startsWith("--")) {
        if (knownArgs.includes(arg.slice(2))) {
            return arg.slice(2);
        }
    }
    return arg;
});

let command = "npx cmake-js " + cmakeJSArgs.join(' ');

import yargs from 'yargs';
let args = yargs(process.argv.slice(2)).parse();

let buildArch = args.target_arch || process.env.npm_config_target_arch || process.arch;

// console.log("Args: ", process.argv);
// console.log("Smart args:", args);
// console.log("Arch args: ", args.target_arch, process.env.npm_config_target_arch, process.arch);
const debugBuild = args.D;

const photoChemistryDir = path.join(__dirname, '..', '..', 'libphotochemistry');
console.log("photoChemistryDir is", photoChemistryDir);

if (!photoChemistryDir) {
    console.error("Error: 'node-photochemistry' directory not found.");
    process.exit(1);
}

// Remove the files node_modules/.bin/rc and node_modules/.bin/rc.cmd if they exist,
// isince these interfere with the rc command used for compilation on Windows
let rcFiles = ['rc', 'rc.cmd'];
rcFiles.forEach((rcFile) => {
    let rcPath = path.join(__dirname, '../node_modules/.bin', rcFile);
    if (fs.existsSync(rcPath)) {
        fs.unlinkSync(rcPath);
    }
});

let buildDir = path.join(photoChemistryDir, 'build/node', buildArch)
// Create build dir if it doesn't exist
if (!fs.existsSync(buildDir)) {
    fs.mkdirSync(buildDir, { recursive: true });
}

console.log("buildArch is", buildArch);

// Use correct build dir
command += ` -O "${buildDir}"`
// Use vcpkg
command += ` -a ${buildArch}`
command += ` -T node-photochemistry`
command += ` -d ${path.join(__dirname, '..')}`
// Set generator to Ninja
command += ` -G Ninja`
if (debugBuild) {
    command += ` --CDCMAKE_BUILD_TYPE=Debug`;
} else {
    command += ` --CDCMAKE_BUILD_TYPE=RelWithDebInfo`;
}
command += ` --CDNODE_ARCH=${buildArch}`
command += ` --CDCMAKE_TOOLCHAIN_FILE="${photoChemistryDir}/third_party/vcpkg/scripts/buildsystems/vcpkg.cmake"`

execFileSync(command, {
    stdio: 'inherit',
    shell: true,
});

if (command.includes(" compile")  || command.includes(" build")) {
    // add 'Release' to the buildDir if on windows
    // (commented out because this isn't the case when using the Ninja generator)
    let outputDir = /*platform() === 'win32' ? path.join(buildDir, 'Release') :*/ buildDir;

    // Copy the built .node file from buildDir to ./build
    let outputFile = path.join(outputDir, 'node-photochemistry.node');
    let destFile = path.join(__dirname, '../build/photochemistry.node');
    // Create dest dir if it doesn't exist
    if (!fs.existsSync(path.dirname(destFile))) {
        fs.mkdirSync(path.dirname(destFile), { recursive: true });
    }
    fs.copyFileSync(outputFile, destFile);
}

process.exit(0);
