#ifndef NODE_PCH_PROCESSFILEDIRECTORY
#define NODE_PCH_PROCESSFILEDIRECTORY

#include <napi.h>
#include "photochemistry/storage/processfiledirectory.hpp"

class PCHProcessFileDirectory : public Napi::ObjectWrap<PCHProcessFileDirectory> {
public:
    static Napi::Object Init(Napi::Env env, Napi::Object exports);
    PCHProcessFileDirectory(const Napi::CallbackInfo& info);
    enum class ProcessFileImageSize {
        THUMBNAIL = 0,
        HALFSIZE = 1,
        FULLSIZE = 2,
    };

    // TODO: Make this an EventEmitter
private:
    bool _hasChanged = false;
    void reload(const Napi::CallbackInfo& info);
    Napi::Value listFiles(const Napi::CallbackInfo& info);
    Napi::Value getProcessFile(const Napi::CallbackInfo& info);
    Napi::Value getProcessFileProperties(const Napi::CallbackInfo& info);
    void getImageTexture16F(const Napi::CallbackInfo& info);
    Napi::Value hasChanged(const Napi::CallbackInfo& info);

    void setProcessFileProperties(const Napi::CallbackInfo& info);
    void applyProcessFileProperties(const Napi::CallbackInfo& info);
    void adjustProcessFileAdjustment(const Napi::CallbackInfo& info);
    void makeProcessFileWithAutoSettings(const Napi::CallbackInfo& info);
    void exportImageFile(const Napi::CallbackInfo& info);

    void flipHorizontally(const Napi::CallbackInfo& info);
    void rotateClockwise(const Napi::CallbackInfo& info);
    void rotateCounterClockwise(const Napi::CallbackInfo& info);
    void revertFiles(const Napi::CallbackInfo& info);

    Napi::Value applyAutoSettingsWithoutSaving(const Napi::CallbackInfo& info);

    //Napi::Value getInputThumbnailImage(const Napi::CallbackInfo& info);
    // void getImage(const Napi::CallbackInfo& info);

    std::shared_ptr<photochemistry::storage::ProcessFileDirectory> dir;

};

#endif