import { defineIntegration, convertIntegrationFnToClass } from '@sentry/core';
import { anrIntegration as anrIntegration$1 } from '@sentry/node';
import { app, powerMonitor } from 'electron';
import { ELECTRON_MAJOR_VERSION } from '../electron-normalize.js';

/**
 * Starts a worker thread to detect App Not Responding (ANR) events
 */
const anrIntegration = defineIntegration((options = {}) => {
    if (ELECTRON_MAJOR_VERSION < 22) {
        throw new Error('Main process ANR detection requires Electron v22+');
    }
    const integration = anrIntegration$1(Object.assign(Object.assign({}, options), { staticTags: Object.assign({ 'event.environment': 'javascript', 'event.origin': 'electron', 'event.process': 'browser' }, options.staticTags), appRootPath: app.getAppPath() }));
    powerMonitor.on('suspend', () => {
        integration.stopWorker();
    });
    powerMonitor.on('resume', () => {
        integration.startWorker();
    });
    return integration;
});
/**
 * @deprecated Use `anrIntegration()` instead.
 */
// eslint-disable-next-line deprecation/deprecation
const Anr = convertIntegrationFnToClass(anrIntegration.name, anrIntegration);

export { Anr, anrIntegration };
//# sourceMappingURL=anr.js.map
