const browser = require('@sentry/browser');
const index = require('./integrations/index.js');
const core = require('@sentry/core');
const scopeToMain = require('./integrations/scope-to-main.js');
const metricsAggregator = require('./integrations/metrics-aggregator.js');
const sdk = require('./sdk.js');

const metrics = Object.assign(Object.assign({}, core.metrics), { 
    // Override the default browser metrics aggregator with the Electron renderer one
    MetricsAggregator: metricsAggregator.MetricsAggregator });
/**
 * @deprecated All integrations are now exported from the root of the package.
 */
// eslint-disable-next-line deprecation/deprecation
const Integrations = Object.assign(Object.assign({}, browser.Integrations), index);

exports.BrowserClient = browser.BrowserClient;
exports.BrowserProfilingIntegration = browser.BrowserProfilingIntegration;
exports.BrowserTracing = browser.BrowserTracing;
exports.Replay = browser.Replay;
exports.addTracingExtensions = browser.addTracingExtensions;
exports.breadcrumbsIntegration = browser.breadcrumbsIntegration;
exports.browserApiErrorsIntegration = browser.browserApiErrorsIntegration;
exports.browserProfilingIntegration = browser.browserProfilingIntegration;
exports.browserTracingIntegration = browser.browserTracingIntegration;
exports.dedupeIntegration = browser.dedupeIntegration;
exports.feedbackIntegration = browser.feedbackIntegration;
exports.globalHandlersIntegration = browser.globalHandlersIntegration;
exports.httpContextIntegration = browser.httpContextIntegration;
exports.lastEventId = browser.lastEventId;
exports.linkedErrorsIntegration = browser.linkedErrorsIntegration;
exports.replayCanvasIntegration = browser.replayCanvasIntegration;
exports.replayIntegration = browser.replayIntegration;
exports.sendFeedback = browser.sendFeedback;
exports.showReportDialog = browser.showReportDialog;
exports.Hub = core.Hub;
exports.ModuleMetadata = core.ModuleMetadata;
exports.Scope = core.Scope;
exports.addBreadcrumb = core.addBreadcrumb;
exports.addEventProcessor = core.addEventProcessor;
exports.addGlobalEventProcessor = core.addGlobalEventProcessor;
exports.addIntegration = core.addIntegration;
exports.captureCheckIn = core.captureCheckIn;
exports.captureEvent = core.captureEvent;
exports.captureException = core.captureException;
exports.captureMessage = core.captureMessage;
exports.configureScope = core.configureScope;
exports.continueTrace = core.continueTrace;
exports.createTransport = core.createTransport;
exports.extractTraceparentData = core.extractTraceparentData;
exports.functionToStringIntegration = core.functionToStringIntegration;
exports.getActiveSpan = core.getActiveSpan;
exports.getActiveTransaction = core.getActiveTransaction;
exports.getClient = core.getClient;
exports.getCurrentHub = core.getCurrentHub;
exports.getCurrentScope = core.getCurrentScope;
exports.getGlobalScope = core.getGlobalScope;
exports.getHubFromCarrier = core.getHubFromCarrier;
exports.getIsolationScope = core.getIsolationScope;
exports.inboundFiltersIntegration = core.inboundFiltersIntegration;
exports.makeMain = core.makeMain;
exports.moduleMetadataIntegration = core.moduleMetadataIntegration;
exports.parameterize = core.parameterize;
exports.runWithAsyncContext = core.runWithAsyncContext;
exports.setContext = core.setContext;
exports.setExtra = core.setExtra;
exports.setExtras = core.setExtras;
exports.setMeasurement = core.setMeasurement;
exports.setTag = core.setTag;
exports.setTags = core.setTags;
exports.setUser = core.setUser;
exports.spanStatusfromHttpCode = core.spanStatusfromHttpCode;
exports.startActiveSpan = core.startActiveSpan;
exports.startInactiveSpan = core.startInactiveSpan;
exports.startSpan = core.startSpan;
exports.startSpanManual = core.startSpanManual;
exports.startTransaction = core.startTransaction;
exports.trace = core.trace;
exports.withMonitor = core.withMonitor;
exports.withScope = core.withScope;
exports.scopeToMainIntegration = scopeToMain.scopeToMainIntegration;
exports.metricsAggregatorIntegration = metricsAggregator.metricsAggregatorIntegration;
exports.defaultIntegrations = sdk.defaultIntegrations;
exports.init = sdk.init;
exports.Integrations = Integrations;
exports.metrics = metrics;
//# sourceMappingURL=index.js.map
