const core = require('@sentry/core');
const node = require('@sentry/node');
const electron = require('electron');
const electronNormalize = require('../electron-normalize.js');

/**
 * Starts a worker thread to detect App Not Responding (ANR) events
 */
const anrIntegration = core.defineIntegration((options = {}) => {
    if (electronNormalize.ELECTRON_MAJOR_VERSION < 22) {
        throw new Error('Main process ANR detection requires Electron v22+');
    }
    const integration = node.anrIntegration(Object.assign(Object.assign({}, options), { staticTags: Object.assign({ 'event.environment': 'javascript', 'event.origin': 'electron', 'event.process': 'browser' }, options.staticTags), appRootPath: electron.app.getAppPath() }));
    electron.powerMonitor.on('suspend', () => {
        integration.stopWorker();
    });
    electron.powerMonitor.on('resume', () => {
        integration.startWorker();
    });
    return integration;
});
/**
 * @deprecated Use `anrIntegration()` instead.
 */
// eslint-disable-next-line deprecation/deprecation
const Anr = core.convertIntegrationFnToClass(anrIntegration.name, anrIntegration);

exports.Anr = Anr;
exports.anrIntegration = anrIntegration;
//# sourceMappingURL=anr.js.map
