import { Integrations as Integrations$1 } from '@sentry/node';
export { NodeClient, close, flush, lastEventId } from '@sentry/node';
import * as index from './integrations/index.js';
export { Hub, Scope, addBreadcrumb, addEventProcessor, addGlobalEventProcessor, addIntegration, captureCheckIn, captureEvent, captureException, captureMessage, configureScope, continueTrace, createTransport, extractTraceparentData, functionToStringIntegration, getActiveSpan, getActiveTransaction, getClient, getCurrentHub, getCurrentScope, getGlobalScope, getHubFromCarrier, getIsolationScope, inboundFiltersIntegration, linkedErrorsIntegration, makeMain, metrics, parameterize, requestDataIntegration, runWithAsyncContext, setContext, setExtra, setExtras, setMeasurement, setTag, setTags, setUser, spanStatusfromHttpCode, startActiveSpan, startInactiveSpan, startSpan, startSpanManual, startTransaction, trace, withMonitor, withScope } from '@sentry/core';
export { electronBreadcrumbsIntegration } from './integrations/electron-breadcrumbs.js';
export { onUncaughtExceptionIntegration } from './integrations/onuncaughtexception.js';
export { mainContextIntegration } from './integrations/main-context.js';
export { sentryMinidumpIntegration } from './integrations/sentry-minidump/index.js';
export { electronMinidumpIntegration } from './integrations/electron-minidump.js';
export { preloadInjectionIntegration } from './integrations/preload-injection.js';
export { mainProcessSessionIntegration } from './integrations/main-process-session.js';
export { browserWindowSessionIntegration } from './integrations/browser-window-session.js';
export { additionalContextIntegration } from './integrations/additional-context.js';
export { electronNetIntegration } from './integrations/net-breadcrumbs.js';
export { childProcessIntegration } from './integrations/child-process.js';
export { screenshotsIntegration } from './integrations/screenshots.js';
export { rendererProfileFromIpc } from './integrations/renderer-profiling.js';
export { anrIntegration } from './integrations/anr.js';
export { makeElectronTransport } from './transports/electron-net.js';
export { makeElectronOfflineTransport } from './transports/electron-offline-net.js';
export { defaultIntegrations, init } from './sdk.js';
export { enableMainProcessAnrDetection } from './anr.js';
import { ensureProcess } from '../common/process.js';
export { IPCMode } from '../common/mode.js';

ensureProcess('main');
/**
 * @deprecated All integrations are now exported from the root of the package.
 */
const Integrations = Object.assign(Object.assign({}, Integrations$1), index);

export { Integrations };
//# sourceMappingURL=index.js.map
