const core = require('@sentry/core');
const sessions = require('../sessions.js');

const INTEGRATION_NAME = 'MainProcessSession';
/** Tracks sessions as the main process lifetime. */
const mainProcessSessionIntegration = core.defineIntegration((options = {}) => {
    return {
        name: INTEGRATION_NAME,
        setupOnce() {
            // noop
        },
        setup() {
            sessions.startSession(!!options.sendOnCreate);
            sessions.endSessionOnExit();
        },
    };
});
/**
 * Tracks sessions as the main process lifetime.
 *
 * @deprecated Use `mainProcessSessionIntegration()` instead
 */
// eslint-disable-next-line deprecation/deprecation
const MainProcessSession = core.convertIntegrationFnToClass(INTEGRATION_NAME, mainProcessSessionIntegration);

exports.MainProcessSession = MainProcessSession;
exports.mainProcessSessionIntegration = mainProcessSessionIntegration;
//# sourceMappingURL=main-process-session.js.map
