import { defineIntegration, convertIntegrationFnToClass } from '@sentry/core';
import { startSession, endSessionOnExit } from '../sessions.js';

const INTEGRATION_NAME = 'MainProcessSession';
/** Tracks sessions as the main process lifetime. */
const mainProcessSessionIntegration = defineIntegration((options = {}) => {
    return {
        name: INTEGRATION_NAME,
        setupOnce() {
            // noop
        },
        setup() {
            startSession(!!options.sendOnCreate);
            endSessionOnExit();
        },
    };
});
/**
 * Tracks sessions as the main process lifetime.
 *
 * @deprecated Use `mainProcessSessionIntegration()` instead
 */
// eslint-disable-next-line deprecation/deprecation
const MainProcessSession = convertIntegrationFnToClass(INTEGRATION_NAME, mainProcessSessionIntegration);

export { MainProcessSession, mainProcessSessionIntegration };
//# sourceMappingURL=main-process-session.js.map
